--[[
===================================================================
 Mineiro MuOnline - Scripts RoxGaming
 Criador : Mineiro MuOnline
 YouTube : https://www.youtube.com/@MineiroMuOnline
 Contato : +55 (31) 98255-6150  [Mineiro MuOnline / RoxGaming]
 Ano     : 2025
===================================================================
]]--

-- Controle de Kills (Pk) e Hero em tempo real!
-- Ativa/Desativa completamente o sistema de PK/Hero
local EnablePkHeroSystem = false

local Table = "Character"

-- >>> CONFIGURAÇÕES <<<
-- Ativa/Desativa a verificação de mapa
local VerificarMapa = true
-- Mapas permitidos para contagem de pontos (ex: 0 = Lorencia, 1 = Dungeon, etc) - { 0, 1, 2, 3, 4, 6, ...}
local MapasPermitidos = { 6 }

-- >>> CONFIGURAÇÕES PK SYSTEM<<<
-- Ativa/Desativa o sistema de pontuação por PK
local PkSystemSwitch = true

--Ativa/Desativa Contagem de pontos pk total
local PkCountPoints = true
local ColunaPkCountPoints = "PKTotal"

--Ativa/Desativa Contagem de pontos pk diario
local PkCountPointsDay = true
local ColunaPkCountPointsDay = "PKDay"

--Ativa/Desativa Contagem de pontos pk semanal
local PkCountPointsWek = true
local ColunaPkCountPointsWek = "PKWeek"

--Ativa/Desativa Contagem de pontos pk mensal
local PkCountPointsMon = true
local ColunaPkCountPointsMon = "PKMonth"

-- >>> CONFIGURAÇÕES HERO SYSTEM<<<
-- Ativa ou desativa o sistema de pontuação por matar PK lvl 3 (6)
local HeroSystemSwitch = true

--Ativa/Desativa Contagem de pontos hero total
local HeroCountPoints = true
local ColunaHeroCountPoints = "HeroTotal"

--Ativa/Desativa Contagem de pontos hero diario
local HeroCountPointsDay = true
local ColunaHeroCountPointsDay = "HeroDay"

--Ativa/Desativa Contagem de pontos hero semanal
local HeroCountPointsWek = true
local ColunaHeroCountPointsWek = "HeroWeek"

--Ativa/Desativa Contagem de pontos hero mensal
local HeroCountPointsMon = true
local ColunaHeroCountPointsMon = "HeroMonth"

-- Função para checar se o mapa atual está na lista permitida
local function MapaEhPermitido(map)
    for i = 1, #MapasPermitidos do
        if MapasPermitidos[i] == map then
            return true
        end
    end
    return false
end

GameServerFunctions.PlayerDie(function(pkIndex, heroIndex)
    -- Verificação geral do sistema
    if not EnablePkHeroSystem then
        return
    end

    local pk = User.new(pkIndex)
    local hero = User.new(heroIndex)

    -- Verificação se os 2 são Players ou monstros, se for monstro interrompe o sistema, se for player prossiga!
    if pk:getType() ~= 1 or hero:getType() ~= 1 then
        return
    end

    if VerificarMapa then
        local mapNumber = pk:getMapNumber()
        if not MapaEhPermitido(mapNumber) then
            SendMessage("[Sistema] Este mapa não contabiliza pontos de PK/Hero!", pkIndex, 1)
            return
        end
    end

    local pkName = pk:getName()
    local heroPKLevel = hero:getPKLevel()
    local pkPKLevel = pk:getPKLevel()

    --Sistema Contagem de PK
    -- Se o PkLevel do Player que matou for =6, adiciona 1 ponto nas colunas de PK
    if PkSystemSwitch and pkPKLevel == 6 then
        local updates = {}

        if PkCountPoints then
            table.insert(updates, string.format("%s = %s + 1", ColunaPkCountPoints, ColunaPkCountPoints))
        end
        if PkCountPointsDay then
            table.insert(updates, string.format("%s = %s + 1", ColunaPkCountPointsDay, ColunaPkCountPointsDay))
        end
        if PkCountPointsWek then
            table.insert(updates, string.format("%s = %s + 1", ColunaPkCountPointsWek, ColunaPkCountPointsWek))
        end
        if PkCountPointsMon then
            table.insert(updates, string.format("%s = %s + 1", ColunaPkCountPointsMon, ColunaPkCountPointsMon))
        end

        if #updates > 0 then
            local query = string.format("UPDATE %s SET %s WHERE Name = '%s'", Table, table.concat(updates, ", "), pkName)
            CreateAsyncQuery("UpdateKills", query, -1, 0)
            SendMessage("[Sistema] Você ganhou +1 ponto no Ranking PK.", pkIndex, 1)
        end
    end

    --Sistema Contagem de Hero
    -- Se o PkLevel do Player que morreu for = 6 e o PkLevel do que matou for < ou = 3, adiciona 1 ponto nas colunas
    if HeroSystemSwitch and heroPKLevel == 6 and pkPKLevel <= 3 then
        local updates = {}

        if HeroCountPoints then
            table.insert(updates, string.format("%s = %s + 1", ColunaHeroCountPoints, ColunaHeroCountPoints))
        end
        if HeroCountPointsDay then
            table.insert(updates, string.format("%s = %s + 1", ColunaHeroCountPointsDay, ColunaHeroCountPointsDay))
        end
        if HeroCountPointsWek then
            table.insert(updates, string.format("%s = %s + 1", ColunaHeroCountPointsWek, ColunaHeroCountPointsWek))
        end
        if HeroCountPointsMon then
            table.insert(updates, string.format("%s = %s + 1", ColunaHeroCountPointsMon, ColunaHeroCountPointsMon))
        end

        if #updates > 0 then
            local query = string.format("UPDATE %s SET %s WHERE Name = '%s'", Table, table.concat(updates, ", "), pkName)
            CreateAsyncQuery("UpdateHeroTotal", query, -1, 0)
            SendMessage("[Sistema] Você ganhou +1 ponto no Ranking Heroi.", pkIndex, 1)
        end
    end
end)
