--[[
===================================================================
 Mineiro MuOnline - Scripts RoxGaming
 Criador : Mineiro MuOnline
 YouTube : https://www.youtube.com/@MineiroMuOnline
 Contato : +55 (31) 98255-6150  [Mineiro MuOnline / RoxGaming]
 Ano     : 2025
===================================================================
]]--
Trace = {}

function Trace.Command(aIndex, Arguments)
    if TRACE_SWITCH == 0 then
        return
    end
    
    local player = User.new(aIndex)
    local Language = player:getLanguage()
    
    if player:getAuthority() ~= 32 and CheckGameMasterLevel(player:getAccountID(), player:getName(), TRACE_GAME_MASTER_LEVEL) == 0 then
        return
    end
    
    local Name = command:getString(Arguments, 1, 0)
    local TargetIndex = GetIndex(Name)
    
    if TargetIndex == -1 then
        SendMessage(string.format(TRACE_MESSAGES[Language][1], Name), aIndex, 1)
        return
    end
    
    local playerMap = player:getMapNumber()
    local playerX = player:getX()
    local playerY = player:getY()
    
    if CheckBuffPlayer(TargetIndex, TRACE_EFFECT.BuffIndex) == 0 then
        AddEffect(TargetIndex, 0, TRACE_EFFECT.BuffIndex, 0, 0, 0, 0, 0)
        SendMessage(string.format(TRACE_MESSAGES[Language][2], Name), aIndex, 1)
    end
    
    local function teleportAndRemoveEffect()
        Teleport(TargetIndex, playerMap, playerX, playerY)
        if CheckBuffPlayer(TargetIndex, TRACE_EFFECT.BuffIndex) == 1 then
            RemoveEffect(TargetIndex, TRACE_EFFECT.BuffIndex)
        end
        SendMessage(string.format(TRACE_MESSAGES[Language][3], Name), aIndex, 1)
    end
    
    Timer.TimeOut(TRACE_EFFECT.Duration, teleportAndRemoveEffect)
    
    player = nil
end

Commands.Register(TRACE_COMMAND, Trace.Command)

return Trace